#include "LPC15xx.h"

extern void SCT0_Init(void);

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_SWM    |            // enable SWM clock
                                  EN0_GPIO0  |            // enable GPIO port 0 clock
                                  EN0_GPIO1  |            // enable GPIO port 1 clock
                                  EN0_P_MUX  |            // enable PMUX clock
                                  EN0_IOCON;              // enable IOCON clock

    LPC_SWM->PINASSIGN7        |= 0x00FFFF00;             // ASSIGN7(23:8) = FFFF
    LPC_SWM->PINASSIGN7        &= 0xFF0018FF;             // SCT0_OUT0 = P0.24 = green LED
                                                          // SCT0_OUT1 = P0.0  = red   LED
    LPC_PMUX->SCT0_P_MUX0       = 2;                      // SCT0_IN2  = P0.17 = SW1

    SCT0_Init();                                          // Initialize SCT0

    while (1)                                             // loop forever
    {
    }
}
